<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\BiodataModel;

class Biodata extends BaseController
{
    protected $biodataModel;

    public function __construct()
    {
        $this->biodataModel = new BiodataModel();
    }

    // FRONTEND
    public function frontend()
    {
        return view('frontend/biodata', [
            'biodata' => $this->biodataModel->first()
        ]);
    }

    // BACKEND
    // ===============================
    // READ
    // ===============================
    public function index()
    {
        $keyword = $this->request->getGet('keyword');
        $sort    = $this->request->getGet('sort') ?? 'id';
        $order   = $this->request->getGet('order') ?? 'asc';

        $query = $this->biodataModel;

        // 🔍 SEARCH
        if ($keyword) {
            $query = $query->like('nama', $keyword)
                ->orLike('email', $keyword);
        }

        // ↕ SORTING + 📄 PAGINATION
        $data['biodata'] = $query->orderBy($sort, $order)
            ->paginate(10);

        $data['pager'] = $this->biodataModel->pager;

        return view('biodata/index', $data);
    }


    // ===============================
    // CREATE FORM
    // ===============================
    public function create()
    {
        return view('biodata/create');
    }

    // ===============================
    // STORE
    // ===============================
    public function store()
    {
        $foto = $this->request->getFile('foto');
        $namaFoto = null;

        if ($foto && $foto->isValid()) {
            $namaFoto = $foto->getRandomName();
            $foto->move('uploads/biodata', $namaFoto);
        }

        $this->biodataModel->save([
            'nama'           => $this->request->getPost('nama'),
            'nim'            => $this->request->getPost('nim'),
            'jenis_kelamin'  => $this->request->getPost('jenis_kelamin'),
            'tempat_lahir'   => $this->request->getPost('tempat_lahir'),
            'tanggal_lahir'  => $this->request->getPost('tanggal_lahir'),
            'alamat'         => $this->request->getPost('alamat'),
            'no_hp'          => $this->request->getPost('no_hp'),
            'email'          => $this->request->getPost('email'),
            'foto'           => $namaFoto,
        ]);

        return redirect()->to('/auth/biodata');
    }

    // ===============================
    // EDIT FORM
    // ===============================
    public function edit($id)
    {
        $data['biodata'] = $this->biodataModel->find($id);
        return view('biodata/edit', $data);
    }

    // ===============================
    // UPDATE
    // ===============================
    public function update($id)
    {
        $biodata = $this->biodataModel->find($id);

        $foto = $this->request->getFile('foto');
        $namaFoto = $biodata['foto'];

        if ($foto && $foto->isValid()) {
            // hapus foto lama
            if ($namaFoto && file_exists('uploads/biodata/' . $namaFoto)) {
                unlink('uploads/biodata/' . $namaFoto);
            }

            $namaFoto = $foto->getRandomName();
            $foto->move('uploads/biodata', $namaFoto);
        }

        $this->biodataModel->update($id, [
            'nama'           => $this->request->getPost('nama'),
            'nim'            => $this->request->getPost('nim'),
            'jenis_kelamin'  => $this->request->getPost('jenis_kelamin'),
            'tempat_lahir'   => $this->request->getPost('tempat_lahir'),
            'tanggal_lahir'  => $this->request->getPost('tanggal_lahir'),
            'alamat'         => $this->request->getPost('alamat'),
            'no_hp'          => $this->request->getPost('no_hp'),
            'email'          => $this->request->getPost('email'),
            'foto'           => $namaFoto,
        ]);

        return redirect()->to('/auth/biodata');
    }

    // ===============================
    // DELETE
    // ===============================
    public function delete($id)
    {
        $this->biodataModel->delete($id);
        return redirect()->to('/auth/biodata');
    }
}
